//	main.cpp

#include "DFGadget.h"
#include "time.h"
#include "colors.h"
#include "StLocker.h"


const float cWidth = 38.0;
const char  cColorBar[] = { 
	55, 55, 55, 
	55, 55, 54, 54, 53, 53, 52, 52, 87, 87, 81, 81, 
	75, 75, 69, 69, 250, 250, 229, 229, 249, 249, 
	93, 93, 125, 125, 157, 157, 42, 42,
	42, 42, 42 };


class
PulseApp : public BApplication
{

public:
					PulseApp() : BApplication('????'), 
								fGadget(NULL), fMap(NULL) {}
					~PulseApp() { delete fGadget; }

	virtual void	ReadyToRun();
	virtual void	Pulse();

protected:
	
	DFGadget		*fGadget;
	BBitmap			*fMap;
	BView			*fView;
	
	system_info		fSysInfo;
	double			fThen;	
	
	long			fHeight, fWidth;
};


void
PulseApp::ReadyToRun()
{
	// request gadget
	
	fGadget = new DFGadget(cWidth+4.0, cWidth+4.0);
	
	fMap = new BBitmap(BRect(0,0,cWidth-1.0,16), B_COLOR_8_BIT, TRUE);
	
	fView = new BView(BRect(0,0,cWidth-1.0,16), "pulse", B_FOLLOW_NONE, 0);
	fView->SetLowColor(mdGray);
	fMap->AddChild(fView);
		
	fMap->Lock();
	fView->FillRect(fView->Bounds());
	fView->SetLowColor(black);
	fView->SetHighColor(green);
	fView->Sync();
	fMap->Unlock();
			
	fGadget->SetBitmap(fMap);
	fGadget->SetOffset(BPoint(3,1), BPoint(3,9));
	
	SetPulseRate(250000.0);
	
	// get sysInfo
	
	get_system_info(&fSysInfo);
	
	fThen = system_time();
	
	fHeight = 16 / fSysInfo.cpu_count;
	fWidth = fMap->BytesPerRow();
}	


void
PulseApp::Pulse()
{
	if (fGadget) {
	
		system_info info;
		get_system_info(&info);

		double now = system_time();
				
		fMap->Lock();
		fView->FillRect(BRect(0,0,cWidth-1.0,16), B_SOLID_LOW);

		fView->Sync();
		
		char *p = (char*)fMap->Bits() + (2L * fWidth + 1L);
		
		for (long i=0; i<fSysInfo.cpu_count; i++)
		{
			for (long j=2; j<fHeight; j++)
			{
				long l = 36 
					* (info.cpu_infos[i].active_time
					- fSysInfo.cpu_infos[i].active_time) 
					/ (now - fThen);
				
				if (l > 36) l = 36;
				if (l < 1) l = 1;
				memcpy(p, cColorBar, l);
				
				long l2 = fWidth-l-2;
				if (l2 > 0)
					memset(p+l, 0, l2);
			
				p += fWidth;
			}
			p += fWidth;
		}
		
		fMap->Unlock();
		fGadget->Update();
		
		fSysInfo = info;
		fThen = now;
	}
}
			

int
main()
{
	PulseApp app;

	app.Run();

	return 0;
}
